% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-database.R
\name{create_database}
\alias{create_database}
\title{Create database \link{deprecated}}
\usage{
create_database(
  pa,
  xset,
  xsa = NULL,
  out_dir = ".",
  grp_peaklist = NA,
  db_name = NA
)
}
\arguments{
\item{pa}{purityA object; Needs to be the same used for frag4feature function}

\item{xset}{xcms object; Needs to be the same used for frag4feature function (this will be ignored when using xsa parameter)}

\item{xsa}{CAMERA object [optional]; if CAMERA object is used, we ignore the xset parameter input and obtain all information
from the xset object nested with the CAMERA xsa object. Adduct and isotope information
will be included into the database when using this parameter. The underlying xset object must
be the one used for the frag4feature function}

\item{out_dir}{character; Out directory for the SQLite result database}

\item{grp_peaklist}{dataframe [optional]; Can use any peak dataframe. Still needs to be derived from the xset object though}

\item{db_name}{character [optional]; Name of the result database}
}
\value{
path to SQLite database and database name
}
\description{
Create and SQLite database of an LC-MS(/MS) experiment

msPurity::create_database is deprecated. Please use msPurity::createDatabase for future use
}
\examples{

#msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
#            package="msPurityData"), full.names = TRUE, pattern = "MSMS")
#xset <- xcms::xcmsSet(msmsPths)
#xset <- xcms::group(xset)

#pa  <- purityA(msmsPths)
#pa <- frag4feature(pa, xset)
#pa <- averageAllFragSpectra(pa)
#db_pth <- create_database(pa, xset)

# Run from previously generated data
pa <- readRDS(system.file("extdata", "tests", "purityA",
                          "9_averageAllFragSpectra_with_filter_pa_OLD.rds",
                          package="msPurity"))
xset <- readRDS(system.file("extdata","tests", "xcms",
                            "msms_only_xset_OLD.rds", package="msPurity"))

# Need to ensure the filelists are matching
msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
                                   package="msPurityData"),
                                   full.names = TRUE, pattern = "MSMS")
pa@fileList[1] <- msmsPths[basename(msmsPths)=="LCMSMS_1.mzML"]
pa@fileList[2] <- msmsPths[basename(msmsPths)=="LCMSMS_2.mzML"]
xset@filepaths[1] <- msmsPths[basename(msmsPths)=="LCMSMS_1.mzML"]
xset@filepaths[2] <- msmsPths[basename(msmsPths)=="LCMSMS_2.mzML"]
db_pth <- create_database(pa, xset)
}
