% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleData.R
\name{scaleData}
\alias{scaleData}
\title{Standardize a matrix to have optionally row means zero and variances one, and/or column means zero and variances one.}
\usage{
scaleData(
  object,
  maxit = 20,
  thresh = 1e-09,
  row.center = TRUE,
  row.scale = TRUE,
  col.center = TRUE,
  col.scale = TRUE,
  trace = FALSE
)
}
\arguments{
\item{object}{numeric matrix giving log-intensity where missing values are denoted by NA. Rows are peptides, columns are samples.}

\item{maxit}{numeric. maximum iteration for the algorithm to converge (default to 20). When both row and column centering/scaling is requested, iteration may be necessary.}

\item{thresh}{numeric. Convergence threshold (default to 1e-09).}

\item{row.center}{logical. if row.center==TRUE (the default), row centering will be performed resulting in a matrix with row means zero. If row.center is a vector, it will be used to center the rows. If row.center=FALSE nothing is done.}

\item{row.scale}{if row.scale==TRUE, the rows are scaled (after possibly centering, to have variance one. Alternatively, if a positive vector is supplied, it is used for row centering.}

\item{col.center}{Similar to row.center}

\item{col.scale}{Similar to row.scale}

\item{trace}{logical. With trace=TRUE, convergence progress is reported, when iteration is needed.}
}
\value{
A list of two components: E and E.scaled. E contains the input matrix, E.scaled contains the scaled data
}
\description{
Standardize a matrix to have optionally row means zero and variances one, and/or column means zero and variances one.
}
\details{
Standardizes rows and/or columns of a matrix with missing values, according to the \code{biScale} algorithm in Hastie et al. 2015.
Data is assumed to be normalised and log-transformed. Please note that data scaling might not be appropriate for MS1 data. A good strategy
is to compare mean-variance plot (\code{plotCV2}) before and after imputation. If the plots look differently, you may need to skip
data scaling. The MS1 data are more variable (tend to have higher CV^2), and may contain outliers which will skew the scaling.
}
\examples{
data(pxd010943)
y <- pxd010943
y <- log2(y)
keep <- (rowSums(!is.na(y)) >= 4)
y <- as.matrix.data.frame(y[keep,])
y <- scaleData(y, maxit=30)
}
\references{
Hastie, T., Mazumder, R., Lee, J. D., & Zadeh, R. (2015). Matrix completion and low-rank SVD via fast alternating least squares. The Journal of Machine Learning Research, 16(1), 3367-3402.

Hediyeh-zadeh, S., Webb, A. I., & Davis, M. J. (2020). MSImpute: Imputation of label-free mass spectrometry peptides by low-rank approximation. bioRxiv.
}
\seealso{
selectFeatures, msImpute
}
