% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreHistogramSingleSeq}
\alias{scoreHistogramSingleSeq}
\title{Score histogram on a single sequence}
\usage{
scoreHistogramSingleSeq(seq, pfm, bg)
}
\arguments{
\item{seq}{A DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{scores}{Vector of scores}
\item{dist}{Score distribution}
}
}
\description{
This function computes the empirical score
distribution by normalizing the observed score histogram
for a given sequence.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the per-position and per-strand scores
motifcounter:::scoreHistogramSingleSeq(seqs[[1]], motif, bg)

}
