% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreHistogram}
\alias{scoreHistogram}
\title{Score histogram}
\usage{
scoreHistogram(seqs, pfm, bg)
}
\arguments{
\item{seqs}{A DNAStringSet or DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{scores}{Vector of scores}
\item{dist}{Score distribution}
}
}
\description{
This function computes the empirical score
distribution for a given set of DNA sequences.
}
\details{
It can be used to compare the empirical score
distribution against the theoretical one (see \code{\link{scoreDist}}).
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the empirical score histogram
scoreHistogram(seqs, motif, bg)

}
\seealso{
\code{\link{scoreDist}}
}
