% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_wrapper.R
\name{scoreDistBf}
\alias{scoreDistBf}
\title{Score distribution}
\usage{
scoreDistBf(pfm, bg)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{scores}{Vector of scores}
\item{dist}{Score distribution}
}
}
\description{
This function computes the score distribution for a given PFM and
a background model.
}
\details{
The result of this function is identical to \code{\link{scoreDist}},
however, the method employs a less efficient algorithm that
enumerates all DNA sequences of the length of the motif.
This function is only used for debugging and testing purposes
and might require substantial computational
resources for long motifs.
}
\examples{

# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the score distribution
dp = motifcounter:::scoreDistBf(motif, bg)

}
\seealso{
\code{\link{scoreDist}}
}
