% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_wrapper.R
\name{motifHitProfile}
\alias{motifHitProfile}
\title{Motif hit profile across multiple sequences}
\usage{
motifHitProfile(seqs, pfm, bg)
}
\arguments{
\item{seqs}{A DNAStringSet or DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}
}
\value{
List containing
\describe{
\item{fscores}{Per-position average forward strand motif hits}
\item{rscores}{Per-position average reverse strand motif hits}
}
}
\description{
This function computes the per-position average motif hit
profile across a set of fixed-length DNA sequences.
It can be used to reveal positional constraints
of TFBSs.
}
\examples{



# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)
seqs = seqs[1:10]

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Compute the motif hit profile
motifHitProfile(seqs, motif, bg)

}
