% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMotifLogo.R
\name{plotMotifLogoA}
\alias{plotMotifLogoA}
\title{plot sequence logo without plot.new}
\usage{
plotMotifLogoA(
  pfm,
  font = "sans",
  fontface = "bold",
  ic.scale = TRUE,
  draw = TRUE
)
}
\arguments{
\item{pfm}{an object of pfm}

\item{font}{font of logo}

\item{fontface}{fontface of logo}

\item{ic.scale}{logical If TRUE, the height of each column is proportional
to its information content. Otherwise, all columns have the same height.}

\item{draw}{Vector (logical(1)). TRUE to plot. FALSE, return a gList}
}
\value{
none
}
\description{
plot amino acid or DNA sequence logo in a given canvas
}
\examples{

pcm<-matrix(runif(40,0,100),nrow=4,ncol=10)
pfm<-pcm2pfm(pcm)
rownames(pfm)<-c("A","C","G","T")
motif <- new("pfm", mat=pfm, name="bin_SOLEXA")
plotMotifLogoA(motif)

}
