% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_annotation.R
\name{get_annotation_orgdb}
\alias{get_annotation_orgdb}
\title{Get an annotation data frame from org db packages}
\usage{
get_annotation_orgdb(
  de_container,
  orgdb_package,
  id_type,
  key_for_genenames = "SYMBOL"
)
}
\arguments{
\item{de_container}{An object containing the data for a Differential
Expression workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqDataSet} object, normally obtained after
running your data through the \code{DESeq2} framework.}

\item{orgdb_package}{Character string, named as the \code{org.XX.eg.db}
package which should be available in Bioconductor}

\item{id_type}{Character, the ID type of the genes as in the row names of
the \code{de_container}, to be used in the call to \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::mapIds()}}}

\item{key_for_genenames}{Character, corresponding to the column name for the
key in the orgDb package containing the official gene name (often called
gene symbol).
This parameter defaults to "SYMBOL", but can be adjusted in case the key is not
found in the annotation package (e.g. for \code{org.Sc.sgd.db}).}
}
\value{
A data frame to be used for annotation of genes, with the main
information encoded in the \code{gene_id} and \code{gene_name} columns.
}
\description{
Get an annotation data frame from org db packages
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")

# dds object
data(gse, package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)

anno_df <- get_annotation_orgdb(dds_macrophage, "org.Hs.eg.db", "ENSEMBL")

head(anno_df)
}
