% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqlogo.R
\name{seqLogoGrob}
\alias{seqLogoGrob}
\title{Create a simple sequence logo grob.}
\usage{
seqLogoGrob(x, xmax = NULL, ymax = 2, xjust = c("left", "center", "right"))
}
\arguments{
\item{x}{A \code{\link[TFBSTools]{PFMatrix}} object}

\item{xmax}{A numeric scalar with the maximal width for the logo 
(in base-pairs). A value of \code{NULL} will scale the logo to the 
full width of the viewport.}

\item{ymax}{A numeric scalar with the maximal height for the logo (in bits)
A value of \code{NULL} will scale the logo to the full height of the
viewport.}

\item{xjust}{A character scalar specifying the horizontal adjustment of the
sequence log withint the viewport; one of \code{"left"}, \code{"center"} 
or \code{"right"}.}
}
\value{
A polygon grob.
}
\description{
Create a simple sequence logo grob (grid-graphics object) for a
    transcription factor from a position frequency matrix. The logo drawing
    code is a simplified version from \code{\link[seqLogo]{seqLogo}} and for
    example can be used to embedd sequence logos within other plots.
}
\examples{
if (require(JASPAR2020) && require(TFBSTools) && require(gridExtra)) {
    pfm1 <- getMatrixByID(JASPAR2020, "MA0139")
    pfm2 <- getMatrixByID(JASPAR2020, "MA0531")

    g1 <- seqLogoGrob(pfm1)
    g2 <- seqLogoGrob(pfm2)

    gridExtra::grid.arrange(g1, g2)
}

}
\seealso{
\code{\link[seqLogo]{seqLogo}} for the original, more flexible 
    version of this function.
}
