% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotBinHist}
\alias{plotBinHist}
\title{Histogram of binned elements.}
\usage{
plotBinHist(
  x,
  b,
  breaks = 6 * nlevels(b),
  xlab = deparse(substitute(x, env = as.environment(-1))),
  ylab = "Frequency",
  main = "",
  legendPosition = "right",
  legend = NULL,
  legend.cex = NULL,
  ...
)
}
\arguments{
\item{x}{A numerical vector with the values used for binning.}

\item{b}{A factor that groups elements of \code{x} into bins (typically
the output of \code{\link{bin}}).}

\item{breaks}{A \code{numeric} scalar controlling the histogram breaks
(passed to \code{geom_hist(..., bins = breaks)}).}

\item{xlab, ylab, main}{\code{character} scalars that set the x-axis label,
y-axis label and the main title. Use \code{""} to suppress the label.}

\item{legendPosition}{A \code{character} scalar.
If not \code{"none"}, draw a legend with binning information. The value
is used to control the legend position and will be passed to
\code{theme(legend.position = legendPosition)}.}

\item{legend}{Deprecated (ignored). Please use \code{legendPosition} to
control the drawing and position of the legend.}

\item{legend.cex}{Deprecated (ignored). You can use
\code{\link[ggplot2]{theme}} to set legend and other graphical
parameters.}

\item{...}{Further arguments passed to \code{\link{getColsByBin}}.}
}
\value{
The generated histogram as a \code{ggplot} object.
}
\description{
Plot a histogram of binned elements with binning information.
}
\examples{
set.seed(1)
x <- rnorm(100)
b <- bin(x, "equalN", nElements = 10)
plotBinHist(x, b)

}
\seealso{
\code{\link{getColsByBin}}, \code{\link[ggplot2]{geom_histogram}}
}
