% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_HOMER.R
\name{dumpJaspar}
\alias{dumpJaspar}
\title{Dump Jaspar motifs into a HOMER motif file.}
\usage{
dumpJaspar(
  filename,
  pkg = "JASPAR2020",
  opts = list(tax_group = "vertebrates"),
  pseudocount = 1,
  relScoreCutoff = 0.8,
  verbose = FALSE
)
}
\arguments{
\item{filename}{Name of the output file to be created.}

\item{pkg}{Name of the Jaspar package to use (default: \code{JASPAR2020}).}

\item{opts}{A list with search options used in
\code{\link[TFBSTools]{getMatrixSet}}. By default, only vertebrate motifs
are included in the output using
\code{opts = list(tax_group = "vertebrates")}.}

\item{pseudocount}{A numerical scalar with the pseudocount to be added to
each element of the position frequency matrix extracted from Jaspar,
before its conversion to a position probability matrix (default: 1.0).}

\item{relScoreCutoff}{Currently ignored. numeric(1) in [0,1] that sets the
default motif log-odds score cutof to relScoreCutoff * maximal score for
each PWM (default: 0.8).}

\item{verbose}{A logical scalar. If \code{TRUE}, print progress messages.}
}
\value{
\code{TRUE} if successful.
}
\description{
Get motifs from a Jaspar database package (e.g.
    \code{JASPAR2020}) and write them into a HOMER-compatible motif file
    as positional probability matrices.
}
\examples{
dumpJaspar(filename = tempfile(), pkg = "JASPAR2020",
           opts = list(ID = c("MA0006.1")))

}
\seealso{
\code{\link[TFBSTools]{getMatrixSet}} for details on the argument
    \code{opts}. \code{\link{homerToPFMatrixList}} to read a file with
    HOMER-formatted motifs into a \code{\link[TFBSTools]{PFMatrixList}}.
}
