% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqlogo.R
\name{annoSeqlogo}
\alias{annoSeqlogo}
\title{Sequence logo annotation}
\usage{
annoSeqlogo(
  grobL,
  which = c("column", "row"),
  space = unit(0.5, "mm"),
  width = NULL,
  height = NULL,
  gp = gpar(fill = NA, col = NA)
)
}
\arguments{
\item{grobL}{A \code{list} of sequence logo grobs, typically created using
\code{\link{seqLogoGrob}}.}

\item{which}{Whether it is a column annotation or a row annotation?}

\item{space}{The space around the image to the annotation grid borders. The
value should be a unit object.}

\item{width}{Width of the annotation. The value should be an absolute unit.
Width is not allowed to be set for column annotation.}

\item{height}{Height of the annotation. The value should be an absolute unit.
Height is not allowed to be set for row annotation.}

\item{gp}{Graphic parameters for annotation grids. Can be used to control the
background color in the annotation grids.}
}
\value{
An annotation function which can be used in
  \code{\link[ComplexHeatmap]{HeatmapAnnotation}}.
}
\description{
Create an annotation for a \code{\link[ComplexHeatmap]{Heatmap}}
  containing sequence logos.
}
\examples{
if (require(JASPAR2020) && require(TFBSTools) && require(gridExtra)) {
    pfm1 <- getMatrixByID(JASPAR2020, "MA0139")

    g1 <- seqLogoGrob(pfm1)

    anno <- annoSeqlogo(list(g1))
}

}
