% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSampleDistance.R
\name{plotSampleDistance}
\alias{plotSampleDistance}
\title{Sample distance matrix}
\usage{
plotSampleDistance(
  data,
  colours = (grDevices::colorRampPalette(rev(RColorBrewer::brewer.pal(9, "GnBu"))))(255),
  vst = FALSE,
  cellheight = 40,
  cellwidth = 40
)
}
\arguments{
\item{data}{data.frame; originally generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{colours}{character; the colour palette. Default is
\code{ grDevices::colorRampPalette(RColorBrewer::brewer.pal(9, "GnBu"))(100)}}

\item{vst}{logical; to undertake variance stabilizing transformation.
By default, the function uses a regularized log transformation on the data
set, however, this will not suit all experimental designs.}

\item{cellheight}{numeric; individual cell height in points. Default is 40.}

\item{cellwidth}{numeric; individual cell width in points. Default is 40.}
}
\value{
A blue/green scale heatmap illustrating the sample distance.
}
\description{
Draws a simple hierarchical clustered heatmap to observe
sample distance.
}
\details{
In special conditions, regularized log transformation will not suit
the experimental design. For example, an experimental design without
replicates. In this instance, it is preferable to change the default setting
and switch to a variance stabilizing transformation method (\code{vst=TRUE}).
}
\examples{

data("sRNA_data")
p1 <- plotSampleDistance(sRNA_data)

}
