% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRNAfeatures.R
\name{plotRNAfeatures}
\alias{plotRNAfeatures}
\title{Plots the distribution of genomic features in the genome and those that
overlap with sRNA clusters}
\usage{
plotRNAfeatures(
  data,
  annotation,
  repeats = NULL,
  promoterRegions = 1000,
  repeat.type = NULL,
  colors = c("#EEB05AFF", "#E35E28FF", "#4DA284FF", "#4692B0FF", "#134B73FF",
    "#B5361CFF"),
  legend.position = "bottom",
  rmFeatures = NULL
)
}
\arguments{
\item{data}{data.frame; generated by \code{\link[=RNAimport]{RNAimport()}}}

\item{annotation}{path; URL or connection to a GFFFile object. A genome
reference annotation file (.gff/.gff1/.gff2/.gff3). Can be in compressed
format (gzip).}

\item{repeats}{path; URL or connection to a GFFFile object. A genome
reference annotation file, which only contains information on repeat
sequences in the genome (.gff/.gff1/.gff2/.gff3). By default, this is not
required, however if there is a specific repeats annotation file for the
genome it is suggested to supply it. Can be in compressed format (gzip).}

\item{promoterRegions}{numeric; defines the upstream promoter region of
genes. Default is 1000, which refers to promoters set at 1Kb upstream of
genes}

\item{repeat.type}{character; features type in \code{annotation} file to represent
repeats when \code{repeats} not supplied.}

\item{colors}{vector; colours for each feature.}

\item{legend.position}{character; position of legend. Either "none", "left",
"right", "bottom", "top", "inside".}

\item{rmFeatures}{vector; type of genomic features to not consider such as
"gene" or "exon" etc.}
}
\value{
Returns a table containing the number or percentage of overlaps in
the supplied sRNA data set with specific regions in the genome annotation
such as genes, repeats, introns, exons.
}
\description{
Using the RNAfeatures() function, this function plots the
percentage distribution of genomic features in the provided genome annotation
and percentage the distibution of genomic features which overlap sRNA
clusters. This is illustrated as a stacked bar plot.
}
\details{
\code{RNAfeatures} calculates the number or percentage of sRNA clusters which
overlap with genomic features based on their genomic coordinates.
}
\examples{
data("sRNA_data")
features_plot <- plotRNAfeatures(data = sRNA_data,
                       annotation = system.file("extdata",
                       "reduced_chr2_Tomato.gff.gz", package="mobileRNA"))

}
\seealso{
\code{\link[=RNAmergeAnnotations]{RNAmergeAnnotations()}} to merge 2 GFF files into 1.
}
