% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Moanin-class}
\alias{Moanin-class}
\alias{Moanin}
\alias{create_moanin_model,DataFrame-method}
\alias{create_moanin_model}
\alias{create_moanin_model,data.frame-method}
\alias{create_moanin_model,matrix-method}
\alias{create_moanin_model,SummarizedExperiment-method}
\title{Class Moanin}
\usage{
\S4method{create_moanin_model}{DataFrame}(data, meta, ...)

\S4method{create_moanin_model}{data.frame}(data, ...)

\S4method{create_moanin_model}{matrix}(data, meta, ...)

\S4method{create_moanin_model}{SummarizedExperiment}(
  data,
  spline_formula = NULL,
  basis_matrix = NULL,
  group_variable_name = "Group",
  time_variable_name = "Timepoint",
  degrees_of_freedom = NULL,
  log_transform = FALSE,
  drop_levels = TRUE
)
}
\arguments{
\item{data}{The input data. Can be a \code{\link{SummarizedExperiment}} class,
or matrix/data.frame. If the input data is a \code{matrix} or
\code{data.frame}, then the user must also provide input to the \code{meta}
argument, which will be transformed into \code{colData} of the resulting
\code{Moanin} object}

\item{meta}{Meta data on the samples (columns) of the \code{data} argument.
Must be given f input \code{data} is a \code{matrix} or \code{data.frame}.
If input is \code{SummarizedExperiment}, this argument is ignored.}

\item{...}{arguments passed from methods to the \code{SummarizedExperiment}
method.}

\item{spline_formula}{formula object, optional, default: NUlL. Used to
construct splines from the data in \code{meta}. See details.}

\item{basis_matrix}{matrix, optional, default: NULL. A basis matrix, where
each row corresponds to the evaluation of a sample on the basis function
(thus one column for each basis function).}

\item{group_variable_name}{A character value giving the column that
corresponds to the grouping variable to test for DE. By default "Group"}

\item{time_variable_name}{A character value giving the column that corresponds
to the time variable. By default "Timepoint".}

\item{degrees_of_freedom}{int, optional. Number of degrees of freedom to use
if neither the basis_matrix nor the spline_formula is provided. If not
provided by the user, internally will be set to 4}

\item{log_transform}{whether the data should be log-transformed by certain
methods (see \code{\link{splines_kmeans}})}

\item{drop_levels}{Logical, whether to perform \code{\link{droplevels}} on the
grouping variable (i.e. remove empty levels)}
}
\value{
An object of class \code{Moanin}
}
\description{
\code{Moanin} is a class that extends
  \code{SummarizedExperiment} and is used to store the additional spline
  basis and meta data for timecourse analysis.

In addition to the slots of the \code{SummarizedExperiment}
class, the \code{Moanin} object has the additional slots described
in the Slots section.

There are several methods implemented for this class. The most
  important methods have their own help page. Simple helper methods are
  described in the Methods section below. For a comprehensive list of methods
  specific to this class see the Reference Manual.

The constructor \code{create_moanin_model} creates an object of
 the class \code{Moanin}.
}
\details{
If neither \code{spline_formula} nor \code{basis_matrix} is given,
 then by default, the function will create a basis matrix based on the
 formula: \preformatted{spline_formula = ~Group:ns(Timepoint, df=4) + Group +
 0}

Note that the meta data will have levels dropped (via 
\code{droplevels}).

Input to \code{data} that is given as a class \code{DataFrame} or
 \code{data.frame} will be converted to class \code{matrix}. The reason
 for this is that use of a \code{data.frame} creates errors in taking duplicate rows/columns of \code{SummarizedExperiment}, as in bootstrapping. 
 Users who absolutely want the object to hold a
 object that is not a matrix can construct a \code{SummarizedExperiment} object
 (which will not convert the input into a \code{matrix}), and
 use this as input to \code{create_moanin_model}.
}
\section{Slots}{

\describe{
\item{\code{time_variable_name}}{character value giving the column in \code{colData}
that defines the time variable (must be of class \code{numeric})}

\item{\code{group_variable_name}}{character value giving the column in \code{colData}
that defines the grouping variable (must be of class \code{factor})}

\item{\code{basis_matrix}}{A basis matrix, where each row corresponds to the
evaluation of a sample on the basis function (thus one column for each
basis function).}

\item{\code{spline_formula}}{a formula. The formula used in creating the basis matrix}

\item{\code{degrees_of_freedom}}{a numeric integer. Number of degrees of freedom used
in creating basis matrix. If NULL, degrees of freedom is not known (usually
if user provided basis without degrees of freedom)}

\item{\code{log_transform}}{logical, whether to log-transform the data for certain
methods}
}}

\examples{
# Load some data
data(exampleData)

# Use the default options
moanin = create_moanin_model(data=testData,meta=testMeta)
moanin

# Change the number of degrees of freedom
moanin = create_moanin_model(data=testData,meta=testMeta, 
   degrees_of_freedom=6)
moanin
}
