% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{moreboxplot}
\alias{moreboxplot}
\title{Boxplot with scatter and density options}
\usage{
moreboxplot(
  x,
  box = TRUE,
  dens = TRUE,
  scatter = "no",
  polygon = TRUE,
  sd = 0.1,
  dcol = NULL,
  scol = NULL,
  dlty = 1,
  dlwd = 1,
  spch = 1,
  gcol = rgb(0, 0, 0, 0.5),
  glty = 2,
  glen = 2001,
  gmin = -100,
  gmax = 100,
  sig = NULL,
  sigfun = wilcox.test,
  sigpars = list(col = 1, lwd = 1, cex = 1, add = "auto"),
  ...
)
}
\arguments{
\item{x}{list, matrix or data.frame}

\item{box}{if TRUE, draws boxes}

\item{dens}{if TRUE, draws densities}

\item{scatter}{if set to "random", draws x-axis randomised scatter points}

\item{polygon}{if TRUE, filles the densities}

\item{sd}{standard deviation of the scatter}

\item{dcol}{color of the densities}

\item{scol}{color of the scatter points}

\item{dlty}{line type of the densities}

\item{dlwd}{line width of the densities}

\item{spch}{type of scatter points}

\item{gcol}{color of the grid}

\item{glty}{line type of the grid}

\item{glen}{length of the grid}

\item{gmin}{minimal point of the grid}

\item{gmax}{maximal point of the grid}

\item{sig}{matrix of n rows and 2 columns, each row is for a pair of
box/violin plots to compare; uses standard wilcox.test}

\item{sigfun}{function of the form f(x,y) with x and y as numerical vectors
and returns a list with one entry "p.value", which is a scalar between 0 and
1}

\item{sigpars}{list of paramters for drawing significance levels; standard
drawing parameters except for "add", which is a number or "auto" stating how
far above or below (negative number) of the largest entry the line is drawn}

\item{...}{optional parameters for boxplot or plot}
}
\value{
transitively closed matrix or graphNEL
}
\description{
Plots a boxplots plus x-axis randomised scatter and mirrored densities
to visualise a distribution.
}
\examples{
D <- matrix(rnorm(100*3), 100, 3)
moreboxplot(D)
}
\author{
Martin Pirkl
}
