% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{fitacc}
\alias{fitacc}
\title{Simulation accuracy.}
\usage{
fitacc(x, y, strict = FALSE, unique = TRUE, type = "ham")
}
\arguments{
\item{x}{mnem object}

\item{y}{simulation object or another mnem object}

\item{strict}{if TRUE, accounts for over/underfitting, i.e.
the number of components}

\item{unique}{if TRUE, phis of x and y are made unique each
(FALSE if strict is TRUE)}

\item{type}{type of accuracy. "ham" for hamming, "sens" for
sensitivity and "spec for Specificity"}
}
\value{
plot of EM convergence
}
\description{
Computes the accuracy of the fit between simulated and
inferred mixture.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
fitacc(result, sim)
fitacc(result, sim, type = "sens")
fitacc(result, sim, type = "spec")
fitacc(result, sim, strict = TRUE, type = "sens")
fitacc(result, sim, strict = TRUE, type = "spec")
}
\author{
Martin Pirkl
}
