% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_and_plot.R
\name{getGeneSets}
\alias{getGeneSets}
\title{Get the mitochondrial gene sets}
\usage{
getGeneSets(
  database = "MitoCarta",
  nametype = "ENSEMBL",
  objectType = "list",
  sections = FALSE
)
}
\arguments{
\item{database}{character string saying the database to use for the analysis.
Either one of "MitoCarta", "Reactome", "GO-CC" and "GO-BP".}

\item{nametype}{character string saying the type of gene name ID. 
Either one of "SYMBOL", "ENTREZID" or "ENSEMBL".}

\item{objectType}{character string saying the type of needed object. 
Either one of "list" or "dataframe".}

\item{sections}{logical. Either to keep the aggregated gene set categories 
or the specific gene sets. Default is FALSE.}
}
\value{
the mitochondrial gene sets.
}
\description{
It returns the mitochondrial gene sets (in form of list or 
data frame) of the four possible databases: "MitoCarta", "Reactome", 
"GO-CC" and "GO-BP".
}
\examples{
MClist <- getGeneSets()

}
