% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-manipulators.R
\name{filter_views}
\alias{filter_views}
\title{Filter spatial units}
\usage{
filter_views(current.views, rows, view = "intraview", ...)
}
\arguments{
\item{current.views}{the current view composition.}

\item{rows}{row (integer) location; positive values to keep (duplicate)
and/or negative to remove.}

\item{view}{the name of the view to be used for filtering.}

\item{...}{logical expressions defined in terms of the variables in
\code{view} passed on to \code{\link[dplyr:filter]{dplyr::filter}()}.}
}
\value{
A mistyR view composition with filtered spatial units from all views.
}
\description{
Select, remove (or duplicate) rows from all views in a composition by their
row locations or according to conditions based on a specific view.
}
\details{
The values in \code{rows} have priority over the other parameters. If
\code{rows} doesn't contain integer values then filtering
is performed based on the view specified in \code{view} and expressions
(\code{\link[dplyr:dplyr_data_masking]{...}}) returning logical values
defined in terms of the variables in \code{view}.
}
\examples{
# Create a view composition with an intraview and filter

library(dplyr)

# get the expression data
data("synthetic")
expr <- synthetic[[1]] \%>\% select(-c(row, col, type))

# compose
misty.views <- create_initial_view(expr)

# select only the first 10 spatial units and preview
misty.views \%>\%
  filter_views(1:10) \%>\%
  str()

# select only the units where the expression of ligA is larger than 0.5
# and preview
misty.views \%>\%
  filter_views(NA, "intraview", ligA > 0.5) \%>\%
  str()
}
\seealso{
<\code{\link[dplyr:dplyr_data_masking]{data-masking}}>.

Other view manipulation functions: 
\code{\link{rename_view}()},
\code{\link{select_markers}()}
}
\concept{view manipulation functions}
