% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view-composers.R
\name{add_juxtaview}
\alias{add_juxtaview}
\title{Generate and add a juxtaview to the current view composition}
\usage{
add_juxtaview(
  current.views,
  positions,
  neighbor.thr = 15,
  prefix = "",
  cached = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{current.views}{the current view composition.}

\item{positions}{a \code{data.frame}, \code{tibble} or a \code{matrix}
with named coordinates in columns and rows for each spatial unit ordered
as in the intraview.}

\item{neighbor.thr}{a threshold value used to indicate the largest distance
between two spatial units that can be considered as neighboring.}

\item{prefix}{a prefix to add to the column names.}

\item{cached}{a \code{logical} indicating whether to cache the calculated view
after the first calculation and to reuse a previously cached view if it
already exists for this sample.}

\item{verbose}{a \code{logical} controlling the verbosity of the output of the
function during execution.}
}
\value{
A mistyR view composition with added juxtaview.
}
\description{
The juxtaview captures the expression of all markers within the immediate
neighborhood of a spatial unit.
}
\details{
The neighborhood of each spatial unit is estimated by constructing a graph by
2D Delaunay triangulation following by removal of edges with length larger than
\code{neighbor.thr}. For each spatial unit the juxtaview contains the sum of
expressions across its estimated neighbors for each marker.
}
\examples{
# Create a view composition of an intraview and a juxtaview.

library(dplyr)

# get the expression data
data("synthetic")
expr <- synthetic[[1]] \%>\% select(-c(row, col, type))
# get the coordinates for each cell
pos <- synthetic[[1]] \%>\% select(row, col)

# compose
misty.views <- create_initial_view(expr) \%>\% add_juxtaview(pos, neighbor.thr = 1.5)

# preview
str(misty.views[["juxtaview.1.5"]])
}
\seealso{
\code{\link{create_initial_view}()} for
    starting a view composition with an intraview only.

Other view composition functions: 
\code{\link{add_paraview}()},
\code{\link{add_views}()},
\code{\link{create_initial_view}()},
\code{\link{create_view}()},
\code{\link{remove_views}()}
}
\concept{view composition functions}
