% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmTwoGroups.R
\name{dmTwoGroups}
\alias{dmTwoGroups}
\title{Differential methylation evaluation over time for scDNA-seq data under the 2-group scenario.}
\usage{
dmTwoGroups(Dat_sce_g1, Dat_sce_g2, BPPARAM = MulticoreParam())
}
\arguments{
\item{Dat_sce_g1}{A \code{SingleCellExperiment} object for group 1, containing:
\itemize{
\item \code{mist_pars}: A numeric matrix in \code{rowData} with estimated parameters for all genomic features (generated by \code{estiParamTwo}).
}}

\item{Dat_sce_g2}{A \code{SingleCellExperiment} object for group 2, containing:
\itemize{
\item \code{mist_pars}: A numeric matrix in \code{rowData} with estimated parameters for all genomic features (generated by \code{estiParamTwo}).
}}

\item{BPPARAM}{A \code{BiocParallelParam} object specifying the parallel backend for computations, as used in \code{bplapply()}. Defaults to \code{MulticoreParam()} for parallel processing.}
}
\value{
A named numeric vector where each value corresponds to a genomic feature (e.g., a gene).
The values represent the integral of the differences between the fitted curves of scDNA methylation
levels for the two groups. The vector is sorted in descending order, with larger values indicating
more drastic differences between the groups.
}
\description{
This function performs differential methylation (DM) analysis to identify genomic features
showing significant changes between two groups along pseudotime. The function models
methylation changes and compares the fitted curves for each group, calculating the integral
of the differences between the curves.
}
\examples{
library(SingleCellExperiment)
data_g1 <- readRDS(system.file("extdata", "group1_sampleData_sce.rds", package = "mist"))
data_g2 <- readRDS(system.file("extdata", "group2_sampleData_sce.rds", package = "mist"))
Dat_sce_g1 <- estiParam(
    Dat_sce = data_g1,
    Dat_name = "Methy_level_group1",
    ptime_name = "pseudotime"
)

Dat_sce_g2 <- estiParam(
    Dat_sce = data_g2,
    Dat_name = "Methy_level_group2",
    ptime_name = "pseudotime"
) 
# Run differential methylation analysis
dm_results <- dmTwoGroups(
    Dat_sce_g1 = Dat_sce_g1,
    Dat_sce_g2 = Dat_sce_g2
)
}
