% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmSingle.R
\name{dmSingle}
\alias{dmSingle}
\title{Differential methylation evaluation over time for scDNA-seq data under the 1-group scenario.}
\usage{
dmSingle(Dat_sce, BPPARAM = MulticoreParam())
}
\arguments{
\item{Dat_sce}{The updated sce object with A numeric matrix of estimated parameters for all genomic features in the rowData, including:
\itemize{
\item \eqn{\beta_0} to \eqn{\beta_4}: Estimated coefficients for the polynomial of degree 4.
\item \eqn{\sigma^2_1} to \eqn{\sigma^2_4}: Estimated variances for each stage along the pseudotime.
}}

\item{BPPARAM}{A \code{BiocParallelParam} object specifying the parallel backend for computations, as used in \code{bplapply()}. Defaults to \code{MulticoreParam()} for parallel processing.}
}
\value{
The updated sce object with A named numeric vector where each value corresponds to a genomic feature
(e.g., a gene) in the rowData. The values represent the minimum area between the fitted curve
of scDNA methylation levels along pseudotime and a constant horizontal line for
each feature. This metric measures the magnitude of methylation level changes
along pseudotime. The values are sorted in descending order, with larger values
indicating more drastic changes.
}
\description{
This function performs DM analysis to identify genomic features showing drastic
changes along pseudotime, by modeling the methylation changes along pseudotime and estimating
the developmental-stage-specific biological variations.
}
\examples{
library(mist)
data <- readRDS(system.file("extdata", "group1_sampleData_sce.rds", package = "mist"))
Dat_sce_new <- estiParam(
    Dat_sce = data,
    Dat_name = "Methy_level_group1",
    ptime_name = "pseudotime"
)
dm_sce <- dmSingle(Dat_sce_new)
}
