% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInputSpecies.R
\name{getInputSpecies}
\alias{getInputSpecies}
\title{Return Miranda data for a given species.}
\usage{
getInputSpecies(
  selection,
  threshold = 60,
  energy = NULL,
  targetIden = NULL,
  mirnaIden = NULL
)
}
\arguments{
\item{selection}{Species (species selection are either for mature miRNA species "Human1","Mouse",
"C.elegans", "Epstein_Barr", "Epstein_Barr_Human",
"Drosophila","Kaposi_Sarcoma", "KSHV_Human",
"Cytomegalovirus","CMV_Human")}

\item{threshold}{miRanda score threshold default 60}

\item{energy}{miRanda folding energy threshold default NULL}

\item{targetIden}{miRanda target identity score default NULL}

\item{mirnaIden}{miRanda mirna identity score default NULL}
}
\value{
data.frame with Miranda data.
}
\description{
Reads Miranda file for a given speicies and returns it as
a data.frame, thresholded by percent identity.
Header options are Score (threshold), Energy-Kcal/Mol(energy),
Subject-IdentityPercent(targetIden), Query-IdentityPercent (mirnaIden)
}
\examples{
x <- getInputSpecies("Epstein_Barr", threshold = 60) # Default is threshold 60
}
\keyword{miranda,}
\keyword{species}
