% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/com_plot.R
\name{pcoa_plot}
\alias{pcoa_plot}
\alias{pcoa_plot,list,data.frame,character-method}
\title{Visulization of components distance / dissimilarity in k dimension.}
\usage{
pcoa_plot(x, des, match, ...)

\S4method{pcoa_plot}{list,data.frame,character}(x, des, match, d1 = 1, d2 = 2, color, shape = NULL, ...)
}
\arguments{
\item{x}{A list generated by `dmr`.}

\item{des}{The corresponding descriptive table.}

\item{match}{The column name of the components IDs in `des` with exactly the
same as rownames in x.}

\item{...}{Additional parameters.}

\item{d1}{The dimension be visualized in x-axis, default `1`.}

\item{d2}{The dimension be visualized in y-axis, default `2`.}

\item{color}{The column name in `des` to be used for different color groups.}

\item{shape}{The column name in `des` to be used for different shape groups,
default `NULL`.}
}
\value{
p The plotted figure.

p The plotted PCoA.
}
\description{
Visulization of components distance / dissimilarity in k dimension.

Visulization of components distance / dissimilarity in k dimension.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
maize <- dmr(maize)
asv_dmr <- .dmr(maize)
des <- des(maize)
p1a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Compartment")
p1b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 3, d2 = 4, color =
"Compartment")
p2a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Host_genotype")
p2b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 1, d2 = 3, color =
"Host_genotype")
p3a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Compartment",
shape = "Soil")
p3b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 1, d2 = 4, color =
"Compartment", shape = "Soil")
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
maize <- dmr(maize)
asv_dmr <- .dmr(maize)
des <- des(maize)
p1a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Compartment")
p1b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 3, d2 = 4, color =
"Compartment")
p2a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Host_genotype")
p2b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 1, d2 = 3, color =
"Host_genotype")
p3a <- pcoa_plot(asv_dmr, des, match = "Sample_ID", color = "Compartment",
shape = "Soil")
p3b <- pcoa_plot(asv_dmr, des, match = "Sample_ID", d1 = 1, d2 = 4, color =
"Compartment", shape = "Soil")
}
