% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_tab.R
\name{norm_tab,mina,ANY-method}
\alias{norm_tab,mina,ANY-method}
\alias{norm_tab,mina,character-method}
\title{Normalize the quantitative table with mina input.}
\usage{
\S4method{norm_tab}{mina,ANY}(x, method, depth = 1000, replace = TRUE, multi = 1, ...)

\S4method{norm_tab}{mina,character}(x, method, depth = 1000, replace = TRUE, multi = 1, ...)
}
\arguments{
\item{x}{An object of the class mina with @tab defined.}

\item{method}{The method used for normalization.}

\item{depth}{The depth for subsampling by rarefying, 1000 by default.}

\item{replace}{Whether to sample with replacement (\code{TRUE} by default) or
without replacement (\code{FALSE}) when using method `raref`.}

\item{multi}{Rarefy the table for multiple times, FALSE by default, indicate
the times of rarefaction want to be repeated, only validate for rarefaction.}

\item{...}{Additional parameters.}
}
\value{
x An object of the class mina with @norm added.
}
\description{
Normalize the quantitative table with mina input.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 1000, replace = TRUE,
multi = 3)
}
