% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{net_cls_tab}
\alias{net_cls_tab}
\title{Get the cluster table 'cls_tab' from `norm` and `cls`.}
\usage{
net_cls_tab(x, uw = FALSE)
}
\arguments{
\item{x}{An object of class `mina` with `norm` and `cls` defined.}

\item{uw}{By summing up the number of present components of each cluster
instead of relative abundances, default is FALSE.}
}
\value{
The network cluster relative abundance table.
}
\description{
Get the cluster table 'cls_tab' from `norm` and `cls`.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 1000)
maize <- fit_tabs(maize)
maize <- adj(maize, method = "spearman")
maize <- net_cls(maize, method = "ap", cutoff = 0.5)
maize <- net_cls_tab(maize)
}
