% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_cls.R
\name{net_cls,matrix,ANY-method}
\alias{net_cls,matrix,ANY-method}
\alias{net_cls,matrix,character-method}
\title{Network clustering based on the sparsed adjacacency matrix.}
\usage{
\S4method{net_cls}{matrix,ANY}(x, method, cutoff = 0.4, neg = FALSE, ...)

\S4method{net_cls}{matrix,character}(x, method, cutoff = 0.4, neg = FALSE, ...)
}
\arguments{
\item{x}{Adjacency matrix used for clustering.}

\item{method}{The clustering method used.}

\item{cutoff}{The cutoff for the sparsed adjacacency matrix, default 0.4.}

\item{neg}{Whether to keep the negative edges, cannot be TRUE when using
`mcl` for clustering. Default FALSE.}

\item{...}{Additional parameters.}
}
\value{
y The cluster table.
}
\description{
Network clustering based on the sparsed adjacacency matrix.
}
\examples{
asv_norm <- norm_tab(maize_asv2, method = "raref", depth = 1000)
asv_adj <- adj(asv_norm, method = "spearman")
asv_cls <- net_cls(asv_adj, method = "mcl")
}
