% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_classes.R
\docType{class}
\name{mina-class}
\alias{mina-class}
\title{Class "mina" includes the quantitative table and descriptive table.}
\description{
Class "mina" includes the quantitative table and descriptive table.
}
\section{Slots}{

\describe{
\item{\code{tab}}{The quantitative table of the dataset.}

\item{\code{des}}{The descriptive table of the samples listed in @tab.}

\item{\code{norm}}{The normalized quantitative table of @tab.}

\item{\code{dis}}{The distance / dissimilarity matrix between samples in @tab.}

\item{\code{dmr}}{The list of dimensionality reduction result, includes points and
variance.}

\item{\code{adj}}{The adjacency matrix between pairwise compositions (e.g. OTUs/ASVs)}

\item{\code{adj_sig}}{The P-value matrix of adjacency matrix, only applicable for
Pearson and Spearman correlation adjacency matrices.}

\item{\code{cls}}{The cluster information for each composition.}

\item{\code{cls_tab}}{The cluster quantitative table.}

\item{\code{multi}}{The list of subsampled adjacency matrices for each environment.}

\item{\code{perm}}{The list of permutated adjacency matrices for each pairwise
environmental comparison.}

\item{\code{dis_bs}}{The distance between networks of different environmental
communities.}

\item{\code{dis_pm}}{The distance between networks of permutated groups.}

\item{\code{dis_stat}}{The average distance between subsampled environmental community
networks, permutated networks and corresponding significance.}
}}

\examples{
maize <- new("mina", tab = maize_asv, des = maize_des)
}
\author{
Rui Guan \url{https://github.com/Guan06}
}
