% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/get_rep.R
\name{get_rep}
\alias{get_rep}
\alias{get_rep,matrix-method}
\title{Get the representative community members by extracting the most abundant and
prevalent compositions.}
\usage{
get_rep(x, ...)

\S4method{get_rep}{matrix}(x, top = 5)
}
\arguments{
\item{x}{A quantitative matrix with samples in columns and compositions in
rows.}

\item{...}{Additional parameters.}

\item{top}{The percent of the most abundant and prevalent members.}
}
\value{
The matrix with samples in columns and representative compositions in
rows.

The matrix with samples in columns and representative compositions in
rows.
}
\description{
Get the representative community members by extracting the most abundant and
prevalent compositions.

Get the representative community members.
}
\examples{
data(maize_asv)
maize_asv_rep <- get_rep(maize_asv)
data(maize_asv)
maize_asv_rep <- get_rep(maize_asv, top = 5)
}
