% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{get_r2}
\alias{get_r2}
\title{Same function as `com_r2` with matrix and corresponding descriptive table as
input.}
\usage{
get_r2(x, des, group)
}
\arguments{
\item{x}{Dissimilarity / distance matrix which indicate variances.}

\item{des}{The descriptive table of samples which define the groups.}

\item{group}{The name(s) of column(s) used  as experimental setup group(s) in
descriptive file.}
}
\value{
r2 The variance ratio cannot be explained by given groups.
}
\description{
Same function as `com_r2` with matrix and corresponding descriptive table as
input.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
get_r2(dis(maize), des(maize), group = c("Compartment", "Soil"))
}
