% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{get_net_cls_tab}
\alias{get_net_cls_tab}
\title{Get the cluster table `cls_tab` from quantitative table `norm` and network
clustering results `cls`.}
\usage{
get_net_cls_tab(x_norm, x_cls, uw = FALSE)
}
\arguments{
\item{x_norm}{The normalized quantitative table used for netowrk inference
and clustering.}

\item{x_cls}{The network clustering table.}

\item{uw}{By summing up the number of present components of each cluster
instead of relative abundance, default is FALSE.}
}
\value{
x_cls The quantitative table with clusters in rows.
}
\description{
Get the cluster table `cls_tab` from quantitative table `norm` and network
clustering results `cls`.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 1000)
maize <- fit_tabs(maize)
maize_norm <- norm(maize)
maize_adj <- adj(maize_norm, method = "spearman")
maize_cls <- net_cls(maize_adj, method = "ap", cutoff = 0.5)
maize_cls_tab <- get_net_cls_tab(maize_norm, maize_cls)
}
