% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmr.R
\name{dmr,matrix-method}
\alias{dmr,matrix-method}
\title{Dimensionality reduction of the distance matrix.}
\usage{
\S4method{dmr}{matrix}(x, k = 4)
}
\arguments{
\item{x}{A distance matrix.}

\item{k}{The number of dimensionality after reduction, 4 by default.}
}
\value{
y The coordinates of components indicated in distance matrix in k
dimension.
}
\description{
Dimensionality reduction of the distance matrix.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
asv_dis <- dis(maize)
asv_dis_dmr <- dmr(asv_dis, k = 4)
}
