% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/com_r2.R
\name{com_r2,mina,ANY-method}
\alias{com_r2,mina,ANY-method}
\alias{com_r2,mina,character-method}
\title{Function for unexplained variance ratio calculation indicated in
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.}
\usage{
\S4method{com_r2}{mina,ANY}(x, group)

\S4method{com_r2}{mina,character}(x, group)
}
\arguments{
\item{x}{An mina object with `dis` and `des` defined.}

\item{group}{The name(s) of column(s) defined as experimental setup group(s).}
}
\value{
r2 The variance ratio cannot be explained by given groups.
}
\description{
Function for unexplained variance ratio calculation indicated in
Anderson, M.J. 2001. A new method for non-parametric multivariate analysis of
variance. Austral Ecology, 26: 32--46.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref")
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
com_r2(maize, group = c("Compartment", "Soil", "Host_genotype"))
}
