% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R
\name{com_plot}
\alias{com_plot}
\title{Visulization of components distance / dissimilarity in k dimension.}
\usage{
com_plot(x, match, ...)
}
\arguments{
\item{x}{An object of class `mina` with `dmr` and `des` defined.}

\item{match}{The column name of the components IDs in `des` which exactly the
same indicated in `dmr`.}

\item{...}{Additional parameters.}
}
\value{
The PCoA plot.
}
\description{
Visulization of components distance / dissimilarity in k dimension.
}
\examples{
maize <- new("mina", tab = maize_asv2, des = maize_des2)
maize <- norm_tab(maize, method = "raref", depth = 5000)
maize <- fit_tabs(maize)
maize <- com_dis(maize, method = "bray")
maize <- dmr(maize)
p1a <- com_plot(maize, match = "Sample_ID", color = "Compartment")
p1b <- com_plot(maize, match = "Sample_ID", d1 = 3, d2 = 4,
color = "Compartment")
p2a <- com_plot(maize, match = "Sample_ID", color = "Host_genotype")
p2b <- com_plot(maize, match = "Sample_ID", d1 = 1, d2 = 3, color =
"Host_genotype")
p3a <- com_plot(maize, match = "Sample_ID", color = "Compartment", shape =
"Soil")
p3b <- com_plot(maize, match = "Sample_ID", d1 = 1, d2 = 4, color =
"Compartment", shape = "Soil")
}
