% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.r, R/marray.r
\docType{methods}
\name{marray}
\alias{marray}
\alias{marray,AffyBatch-method}
\alias{marray,FeatureSet-method}
\alias{marray,PLMset-method}
\alias{marray,oligoPLM-method}
\title{Microarray array}
\usage{
marray(object, type = NULL, select = NULL, transpose = NULL)

\S4method{marray}{AffyBatch}(object, type = "pm", select = NULL,
  transpose = FALSE)

\S4method{marray}{PLMset}(object, type = "residuals", select = NULL,
  transpose = FALSE)

\S4method{marray}{FeatureSet}(object, type = "pm", select = NULL,
  transpose = FALSE)

\S4method{marray}{oligoPLM}(object, type = "residuals", select = NULL,
  transpose = FALSE)
}
\arguments{
\item{object}{a valid Bioconductor microarray data structure}

\item{type}{for microarray objects \code{type} refers to \emph{probe type};
for objects containing probe-level models (e.g., \code{PLMsets})
\code{type} refers to the \emph{value type} (i.e, \code{"residuals"} or
\code{"weights"}). See probe type section for more information.}

\item{select}{a numeric, character or logical vector indicating samples to
include}

\item{transpose}{\code{TRUE} (the default), ensures the reconstructed
microarrays are vertically oriented, as is typically expected. Set to
\code{FALSE} to return an array in the orientation strictly specified by
the platform coordinates}
}
\value{
three-dimensional \code{\link{array}}
}
\description{
Convert S4 microarray data structures into a three-dimensional array of
matrices, where each matrix corresponds to an individual sample's microarray
with values arranged to reflect the physical position of the corresponding
feature (i.e., probe) on the microarray surface.
}
\section{Probe types}{


For microarray data structures the \code{type} argument determines the
\emph{type} of probe that should be included. The following table provides a
list of valid values for each supported microarray class:

\tabular{rcccc}{
\code{AffyBatch}
  \tab \code{"all"} \tab \code{"pm"} \tab \code{"mm"} \tab - \cr
\code{ExpressionFeatureSet}
  \tab \code{"all"} \tab \code{"pm"} \tab \code{"mm"} \tab - \cr
\code{GeneFeatureSet}
  \tab \code{"all"} \tab \code{"pm"} \tab - \tab \code{"bg"}\cr
\code{ExonFeatureSet}
  \tab \code{"all"} \tab \code{"pm"} \tab \code{"mm"} \tab \code{"bg"} \cr
\code{SnpFeatureSet}
  \tab \code{"all"} \tab \code{"pm"} \tab \code{"mm"} \tab - \cr
}
}
\examples{
if (require(affydata, quietly = TRUE)) {
  data("Dilution", package = "affydata")
  dilution.array <- marray(Dilution, select = c("20A", "10A"))
}

}

