% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.r
\name{arank}
\alias{arank}
\title{Array rank}
\usage{
arank(x, na.last = TRUE, ties.method = "first")
}
\arguments{
\item{x}{a three-dimensional \code{\link{array}} of matrices}

\item{na.last}{for controlling the treatment of \code{\link{NA}}s.
    If \code{TRUE}, missing values in the data are put last; if
    \code{FALSE}, they are put first; if \code{NA}, they are removed; if
    \code{"keep"} they are kept with rank \code{NA}.}

\item{ties.method}{a character string specifying how ties are treated,
    see \sQuote{Details}; can be abbreviated.}
}
\value{
an \code{\link{array}} with the same dimensions as \code{x}
}
\description{
Determines the rank of values within each matrix of a three-dimensional
array.
}
\examples{
# microarray visualization
if (require(affydata, quietly = TRUE)) {
  data("Dilution", package = "affydata")
  x <- arank(marray(Dilution, transpose = TRUE))
}

}
\seealso{
\code{\link[base]{rank}}

Other array.transformations: \code{\link{arle}}
}

