% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spreadplot.R
\name{spreadplot}
\alias{spreadplot}
\title{Abundance Spread Plot}
\usage{
spreadplot(x, trunc = 0.001/100, alpha = 0.15, width = 0.35)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object; or a data.frame with fields
"otu" (otu name); "sample" (sample name); and "abundance"
(otu abundance in the given sample)}

\item{trunc}{Truncate abundances lower than this to zero}

\item{alpha}{Alpha level for point transparency}

\item{width}{Width for point spread}
}
\value{
ggplot2 object
}
\description{
Visualize abundance spread for OTUs
}
\examples{
data(dietswap)
p <- spreadplot(transform(dietswap, "compositional"))
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
