% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_mothur2phyloseq.R
\name{read_mothur2phyloseq}
\alias{read_mothur2phyloseq}
\title{Read Mothur Output into a Phyloseq Object}
\usage{
read_mothur2phyloseq(shared.file, consensus.taxonomy.file, mapping.file = NULL)
}
\arguments{
\item{shared.file}{A
\href{http://www.mothur.org/wiki/Shared_file}{shared file}
produced by \emph{mothur}. Identified from the .shared extension}

\item{consensus.taxonomy.file}{Consensus taxonomy file
produced by \emph{mothur}. Identified from with the .taxonomy extension.
See \url{http://www.mothur.org/wiki/ConTaxonomy_file}.}

\item{mapping.file}{Metadata/mapping file with .csv extension}
}
\value{
\code{\link{phyloseq-class}} object.
}
\description{
Read mothur shared and consensus taxonomy files into a
\code{\link{phyloseq-class}} object.
}
\details{
Mothur shared and consensus taxonomy files will be converted to
\code{\link{phyloseq-class}}.
}
\examples{
#otu.file <- system.file(
#"extdata/Baxter_FITs_Microbiome_2016_fit.final.tx.1.subsample.shared",
#   package='microbiome')

#tax.file <- system.file(
#"extdata/Baxter_FITs_Microbiome_2016_fit.final.tx.1.cons.taxonomy",
#   package='microbiome')

#meta.file <- system.file(
#"extdata/Baxter_FITs_Microbiome_2016_mapping.csv",
#   package='microbiome')

#p0 <- read_mothur2phyloseq(
#       shared.file=otu.file,
#       consensus.taxonomy.file=tax.file,
#       mapping.file=meta.file)

}
\author{
Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
\keyword{utilities}
