% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarity.R
\name{rarity}
\alias{rarity}
\title{Rarity Index}
\usage{
rarity(x, index = "all", detection = 0.2/100, prevalence = 20/100)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{index}{If the index is given, it will override the other parameters.
See the details below for description and references of the standard
rarity indices.}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1]). The
required prevalence is strictly greater by default. To include the
limit, set include.lowest to TRUE.}
}
\value{
A vector of rarity indices
}
\description{
Calculates the community rarity index.
}
\details{
The rarity index characterizes the concentration of species at
low abundance.

The following rarity indices are provided:
\itemize{
\item{log_modulo_skewness }{Quantifies the concentration of the least
abundant species by the log-modulo skewness of the arithmetic
abundance classes (see Magurran & McGill 2011). These are typically
right-skewed; to avoid taking log of occasional negative skews,
we follow Locey & Lennon (2016) and use the log-modulo
transformation that adds a value of one to each measure of skewness
to allow logarithmization. The values q=0.5 and n=50 are used here.}
\item{low_abundance }{Relative proportion of the least abundant species,
below the detection level of 0.2\%. The least abundant species are
determined separately for each sample regardless of their prevalence.}
\item{rare_abundance }{Relative proportion of the non-core species,
exceed the given detection level (default 20%)
at the given prevalence (default 20%).
This is complement of the core with the same thresholds.}
}
}
\examples{
data(dietswap)
d <- rarity(dietswap, index='low_abundance')
# d <- rarity(dietswap, index='all')
}
\references{
Kenneth J. Locey and Jay T. Lennon.
Scaling laws predict global microbial diversity.
PNAS 2016 113 (21) 5970-5975; doi:10.1073/pnas.1521291113.

Magurran AE, McGill BJ, eds (2011)
Biological Diversity: Frontiers in Measurement and Assessment
(Oxford Univ Press, Oxford), Vol 12
}
\seealso{
alpha, log_modulo_skewness, rare_abundance, low_abundance
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
