% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rare.R
\name{rare}
\alias{rare}
\title{Rare Microbiota}
\usage{
rare(x, detection, prevalence, include.lowest = FALSE, ...)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{prevalence}{Prevalence threshold (in [0, 1];
strictly greater by default)}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs in core calculation. FALSE by default.}

\item{...}{Arguments to pass.}
}
\value{
Filtered phyloseq object including only rare taxa
}
\description{
Filter the phyloseq object to include only rare (non-core) taxa.
}
\examples{
data(dietswap)
# Detection threshold 0 (strictly greater by default);
# Prevalence threshold 50 percent (strictly greater by default)
pseq <- rare(dietswap, 0, 50/100)
}
\references{
Salonen A, Salojarvi J, Lahti L, de Vos WM. The adult intestinal
core microbiota is determined by analysis depth and health
status. Clinical Microbiology and Infection 18(S4):16-20, 2012
To cite the microbiome R package, see citation('microbiome')
}
\seealso{
core_members
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
