% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{prevalence}
\alias{prevalence}
\title{OTU Prevalence}
\usage{
prevalence(
  x,
  detection = 0,
  sort = FALSE,
  count = FALSE,
  include.lowest = FALSE
)
}
\arguments{
\item{x}{A vector, data matrix or \code{\link{phyloseq}} object}

\item{detection}{Detection threshold for absence/presence
(strictly greater by default).}

\item{sort}{Sort the groups by prevalence}

\item{count}{Logical. Indicate prevalence as fraction of samples
(in percentage [0, 1]; default); or in absolute counts indicating
the number of samples where the OTU is detected (strictly) above the given
abundance threshold.}

\item{include.lowest}{Include the lower boundary of the detection and
prevalence cutoffs. FALSE by default.}
}
\value{
For each OTU, the fraction of samples where a given OTU is
detected. The output is readily given as a percentage.
}
\description{
Simple prevalence measure.
}
\details{
For vectors, calculates the fraction (count=FALSE) or
number (count=TRUE) of samples that exceed the
detection. For matrices, calculates this for each matrix
column. For phyloseq objects, calculates this for each OTU. The
relative prevalence (count=FALSE) is simply the absolute
prevalence (count=TRUE) divided by the number of samples.
}
\examples{
data(peerj32)     
pr <- prevalence(peerj32$phyloseq, detection=0, sort=TRUE, count=TRUE)
}
\references{
A Salonen et al. The adult intestinal core microbiota is determined by 
analysis depth and health status. Clinical Microbiology and Infection 
18(S4):16 20, 2012. 
To cite the microbiome R package, see citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
