% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_regression.R
\name{plot_regression}
\alias{plot_regression}
\title{Visually Weighted Regression Plot}
\usage{
plot_regression(
  formula,
  data,
  B = 1000,
  shade = TRUE,
  shade.alpha = 0.1,
  spag = FALSE,
  mweight = TRUE,
  show.lm = FALSE,
  show.median = TRUE,
  median.col = "white",
  show.CI = FALSE,
  method = loess,
  slices = 200,
  ylim = NULL,
  quantize = "continuous",
  show.points = TRUE,
  color = NULL,
  pointsize = NULL,
  ...
)
}
\arguments{
\item{formula}{formula}

\item{data}{data}

\item{B}{number bootstrapped smoothers}

\item{shade}{plot the shaded confidence region?}

\item{shade.alpha}{shade.alpha: should the CI shading fade out at 
the edges? (by reducing alpha; 0=no alpha decrease, 
0.1=medium alpha decrease, 0.5=strong alpha decrease)}

\item{spag}{plot spaghetti lines?}

\item{mweight}{visually weight the median smoother}

\item{show.lm}{plot the linear regression line}

\item{show.median}{show median smoother}

\item{median.col}{median color}

\item{show.CI}{should the 95\% CI limits be plotted?}

\item{method}{the fitting function for the spaghettis; default: loess}

\item{slices}{number of slices in x and y direction for the shaded
region. Higher numbers make a smoother plot, but takes longer to
draw. I wouldn't go beyond 500}

\item{ylim}{restrict range of the watercoloring}

\item{quantize}{either 'continuous', or 'SD'. In the latter case, 
we get three color regions for 1, 2, and 3 SD (an idea of John Mashey)}

\item{show.points}{Show points.}

\item{color}{Point colors}

\item{pointsize}{Point sizes}

\item{...}{further parameters passed to the fitting function, 
in the case of loess, for example, 'span=.9', or 
'family='symmetric''}
}
\value{
ggplot2 object
}
\description{
Draw regression curve with smoothed error bars 
with Visually-Weighted Regression by Solomon M. Hsiang; see
\url{http://www.fight-entropy.com/2012/07/visually-weighted-regression.html}
The R is modified from Felix Schonbrodt's original code
http://www.nicebread.de/
visually-weighted-watercolor-plots-new-variants-please-vote
}
\examples{
data(atlas1006)
pseq <- subset_samples(atlas1006,
   DNA_extraction_method == 'r' &
   sex == "female" &
   nationality == "UKIE",
   B=10, slices=10 # non-default used here to speed up examples
   )
p <- plot_regression(diversity ~ age, meta(pseq)[1:20,], slices=10, B=10)
}
\references{
See citation('microbiome')
}
\author{
Based on the original version from F. Schonbrodt. 
Modified by Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
