% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_atlas.R
\name{plot_atlas}
\alias{plot_atlas}
\title{Visualize Samples of a Microbiota Atlas}
\usage{
plot_atlas(pseq, x, y, ncol = 2)
}
\arguments{
\item{pseq}{phyloseq object}

\item{x}{Sorting variable for X axis and sample coloring}

\item{y}{Signal variable for Y axis}

\item{ncol}{Number of legend columns.}
}
\value{
ggplot object
}
\description{
Show all samples of a microbiota collection, colored by
specific factor levels (x axis) and signal (y axis).
}
\details{
Arranges the samples based on the given grouping factor (x), and
plots the signal (y) on the Y axis. The samples are randomly ordered
within each factor level. The factor levels are ordered by standard
deviation of the signal (y axis).
}
\examples{
data(atlas1006)
p <- plot_atlas(atlas1006, 'DNA_extraction_method', 'diversity')
p <- plot_atlas(atlas1006, 'DNA_extraction_method', 'Bifidobacterium')
}
\references{
See citation('microbiome');
Visualization inspired by Kilpinen et al. 2008,
Genome Biology 9:R139. DOI: 10.1186/gb-2008-9-9-r139
}
\author{
Leo Lahti \email{leo.lahti@iki.fi}
}
\keyword{utilities}
