% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_taxa.R
\name{merge_taxa2}
\alias{merge_taxa2}
\title{Merge Taxa}
\usage{
merge_taxa2(x, taxa = NULL, pattern = NULL, name = "Merged")
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{taxa}{A vector of taxa names to merge.}

\item{pattern}{Taxa that match this pattern will be merged.}

\item{name}{Name of the merged group.}
}
\value{
Modified phyloseq object
}
\description{
Merge taxonomic groups into a single group.
}
\details{
In some cases it is necessary to place certain OTUs or other
groups into an "other" category. For instance, unclassified groups. This
wrapper makes this easy. This function differs from phyloseq::merge_taxa
by the last two arguments. Here, in merge_taxa2 the user can specify the
name of the new merged group. And the merging can be done based on common
pattern in the name.
}
\examples{
    data(dietswap)
    s <- merge_taxa(dietswap, c())
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
