% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_landscape.R
\name{densityplot}
\alias{densityplot}
\title{Density Plot}
\usage{
densityplot(
  x,
  main = NULL,
  x.ticks = 10,
  rounding = 0,
  add.points = TRUE,
  col = "black",
  adjust = 1,
  size = 1,
  legend = FALSE,
  shading = TRUE,
  shading.low = "white",
  shading.high = "black",
  point.opacity = 0.75
)
}
\arguments{
\item{x}{Data matrix to plot. The first two columns will be visualized as a
cross-plot.}

\item{main}{title text}

\item{x.ticks}{Number of ticks on the X axis}

\item{rounding}{Rounding for X axis tick values}

\item{add.points}{Plot the data points as well}

\item{col}{Color of the data points. NAs are marked with darkgray.}

\item{adjust}{Kernel width adjustment}

\item{size}{point size}

\item{legend}{plot legend TRUE/FALSE}

\item{shading}{Shading}

\item{shading.low}{Color for shading low density regions}

\item{shading.high}{Color for shading high density regions}

\item{point.opacity}{Transparency-level for points}
}
\value{
ggplot2 object
}
\description{
Density visualization for data points overlaid on cross-plot.
}
\examples{
# p <- densityplot(cbind(rnorm(100), rnorm(100)))
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
