% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bimodality.R
\name{bimodality_sarle}
\alias{bimodality_sarle}
\title{Sarle's Bimodality Coefficient}
\usage{
bimodality_sarle(x, bs.iter = 1, type = "Sarle.finite.sample")
}
\arguments{
\item{x}{Data vector for which bimodality will be quantified}

\item{bs.iter}{Bootstrap iterations}

\item{type}{Score type ('Sarle.finite.sample' or 'Sarle.asymptotic')}
}
\value{
Bimodality score
}
\description{
Sarle's bimodality coefficient.
}
\details{
The coefficient lies in (0, 1).

The 'Sarle.asymptotic' version is defined as
\deqn{b=(g^2 + 1) / k}.
This is coefficient of bimodality from Ellison AM Am. J. Bot. 1987, 
for microbiome analysis it has been used for instance in
Shade et al. 2014.

The formula for 'Sarle.finite.sample' (SAS 2012):

\deqn{b=\frac{g^2 + 1}{k + (3(n-1)^2)/((n-2)(n-3))}}
where n is sample size and 

In both formulas, \eqn{g} is sample skewness and \eqn{k} is the kth
standardized moment (also called the sample kurtosis, or
excess kurtosis).
}
\examples{
# b <- bimodality_sarle(rnorm(50), type='Sarle.finite.sample')
}
\references{
\itemize{
  \item{}{Shade et al. mBio 5(4):e01371-14, 2014.}
  \item{}{Ellison AM (1987) Am J Botany 74(8):1280-1288.}
  \item{}{SAS Institute Inc. (2012). SAS/STAT 12.1 user's guide. Cary, NC.}
  \item{}{To cite the microbiome R package, see citation('microbiome')}
}
}
\seealso{
Check the dip.test from the \pkg{DIP} package for a
classical test of multimodality.
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
