% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundances.R
\name{abundances}
\alias{abundances}
\alias{ab,}
\alias{otu}
\title{Abundance Matrix from Phyloseq}
\usage{
abundances(x, transform = "identity")
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{transform}{Transformation to apply. The options include:
'compositional' (ie relative abundance), 'Z', 'log10', 'log10p',
'hellinger', 'identity', 'clr', 'alr', or any method from the
vegan::decostand function.}
}
\value{
Abundance matrix (OTU x samples).
}
\description{
Retrieves the taxon abundance table from
phyloseq-class object and ensures it is systematically returned as
taxa x samples matrix.
}
\examples{
data(dietswap)
a <- abundances(dietswap)
# b <- abundances(dietswap, transform='compositional')
}
\references{
See citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
