% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble_utilities.R
\name{TibbleUtilites}
\alias{TibbleUtilites}
\alias{otu_tibble}
\alias{tax_tibble}
\alias{sample_tibble}
\alias{combine_otu_tax}
\title{Utilities For \code{\link{phyloseq-class}} Slots to Tibbles}
\usage{
otu_tibble(x, column.id = "FeatureID")

tax_tibble(x, column.id = "FeatureID")

sample_tibble(x, column.id = "SampleID")

combine_otu_tax(x, column.id = "FeatureID")
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object.}

\item{column.id}{Provide name for the column which will hold the rownames. 
of slot.}
}
\value{
A \code{tibble}
}
\description{
Utility to convert phyloseq slots to tibbles.
}
\details{
Convert different \code{phyloseq} slots into tibbles.
\code{otu_tibble} gets the otu_table in tibble format. 
\code{tax_tibble} gets the taxa_table in tibble format. 
\code{combine_otu_tax} combines otu_table and taxa_table into one tibble.
}
\examples{
library(microbiome)
data("dietswap")
otu_tib <- otu_tibble(dietswap,column.id="FeatureID")
tax_tib <- tax_tibble(dietswap,column.id="FeatureID")
sample_tib <- sample_tibble(dietswap,column.id="SampleID")
otu_tax <- combine_otu_tax(dietswap,column.id = "FeatureID")
head(otu_tax)

}
\author{
Contact: Sudarshan A. Shetty \email{sudarshanshetty9@gmail.com}
}
