% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transformCounts.R
\name{transformAssay}
\alias{transformAssay}
\alias{transformAssay,SummarizedExperiment-method}
\alias{transformAssay,SingleCellExperiment-method}
\title{Transform assay}
\usage{
transformAssay(x, ...)

\S4method{transformAssay}{SummarizedExperiment}(
  x,
  method,
  assay.type = "counts",
  assay_name = NULL,
  MARGIN = "samples",
  name = method,
  pseudocount = FALSE,
  ...
)

\S4method{transformAssay}{SingleCellExperiment}(x, altexp = NULL, ...)
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{...}{additional arguments passed e.g. on to \code{vegan:decostand}
or \code{philr::philr}.
\itemize{
\item \code{reference}: \code{Character scalar}. Used to
to fill reference sample's column in returned assay when calculating alr.
(Default: \code{NA})
\item \code{ref_vals} Deprecated. Use \code{reference} instead.
\item \code{percentile}: \code{Numeric scalar} or \code{NULL} (css). Used
to set the  percentile value that calculates the scaling factors in the css
normalization. If \code{NULL}, percentile is estimated from the data by
calculating the portion of samples that exceed the \code{threshold}.
(Default: \code{NULL})
\item \code{scaling}: \code{Numeric scalar}. Adjusts the normalization
scale  by dividing the calculated scaling factors, effectively changing
the magnitude of the normalized counts. (Default: \code{1000}).
\item \code{threshold}: \code{Numeric scalar}. For  \code{"css"},
specifies relative difference threshold and determines the first point
where the relative change in  differences between consecutive quantiles
exceeds this threshold. (Default: \code{0.1}) For \code{"cutoff"},
values less than or equal to the threshold are replaced with \code{value}.
(Default: \code{0})
\item \code{value}: \code{Numeric scalar}. For  \code{"cutoff"}, specifies
the replacement value for counts less than or equal to the threshold.
(Default: \code{NA})
\item \code{tree}: \code{phylo}. Phylogeny used in PhILR transformation.
If \code{NULL}, the tree is retrieved from \code{x}.
(Default: \code{NULL}).
\item \code{node.labels}: \code{Character vector}. Linkages between
\code{tree} and \code{x}. Used in PhILR transformation.
(Default: \code{NULL}).
}}

\item{method}{\code{Character scalar}. Specifies the transformation
method.}

\item{assay.type}{\code{Character scalar}. Specifies the name of assay
used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{MARGIN}{\code{Character scalar}. Determines whether the
transformation is applied sample (column) or feature (row) wise.
(Default: \code{"samples"})}

\item{name}{\code{Character scalar}. The name for the transformed assay to
be stored. (Default: \code{method})}

\item{pseudocount}{\code{Logical scalar} or \code{numeric scalar}.
When \code{TRUE}, automatically adds half of the minimum positive
value of \code{assay.type} (missing values ignored by default:
\code{na.rm = TRUE}).
When FALSE, does not add any pseudocount (pseudocount = 0).
Alternatively, a user-specified numeric value can be added as pseudocount.
(Default: \code{FALSE}).}

\item{altexp}{\code{Character vector} or \code{NULL}. Specifies the names
of alternative experiments to which the transformation should also be
applied. If \code{NULL}, the transformation is only applied to the main
experiment. (Default: \code{NULL}).}
}
\value{
\code{transformAssay} returns the input object \code{x}, with a new
transformed abundance table named \code{name} added in the
\code{\link[SummarizedExperiment:assays]{assays}}.
}
\description{
Variety of transformations for abundance data, stored in \code{assay}.
See details for options.
}
\details{
\code{transformAssay} function provides a variety of options for
transforming abundance data. The transformed data is calculated and stored
in a new \code{assay}.

The \code{transformAssay} provides sample-wise (column-wise) or feature-wise
(row-wise) transformation to the abundance table
(assay) based on specified \code{MARGIN}.

The available transformation methods include:

\itemize{

\item 'alr', 'chi.square', 'clr', 'frequency', 'hellinger', 'log',
'normalize', 'pa', 'rank', 'rclr', 'relabundance', 'rrank', 'standardize',
'total': please refer to
\code{\link[vegan:decostand]{decostand}} for details.

\item 'philr': please refer to \code{\link[philr:philr]{philr}} for details.

\item 'css': Cumulative Sum Scaling (CSS) can be used to normalize count data
by accounting for differences in library sizes. By default, the function
determines the normalization percentile for summing and scaling
counts. If you want to specify the percentile value, good default value
might be \code{0.5}. The method is inspired by the CSS methods in
\code{\link[https://www.bioconductor.org/packages/metagenomeSeq/]{metagenomeSeq}}
package.

\item 'log10': log10 transformation can be used for reducing the skewness
of the data.
\deqn{log10 = \log_{10} x}{%
log10 = log10(x)}
where \eqn{x} is a single value of data.

\item 'log2': log2 transformation can be used for reducing the skewness of
the data.
\deqn{log2 = \log_{2} x}{%
log2 = log2(x)}
where \eqn{x} is a single value of data.

\item 'difference': Pairwise differences between features.
Calculates \eqn{x - y} for all unique feature pairs across samples,
where \eqn{x} and \eqn{y} are entries of the specified assay.type.

\item 'division': Pairwise ratios between features.
Calculates \eqn{x / y} for all unique feature pairs across samples,
where \eqn{x} and \eqn{y} are entries of the specified assay.type.

\item 'invnorm': Inverse rank normalisation. Ranks values per
sample/feature and maps them to standard normal quantiles.
\deqn{
z = \Phi^{-1}\!\left(
  \frac{r - \mathrm{offset}}{\,n + 1 - 2\,\mathrm{offset}\,}
\right)
}
Controlled by \code{offset} (default \code{0.5}; also
\code{0.375}=Blom, \code{0}=van der Waerden) and \code{ties.method}
(passed to \code{base::rank}, default \code{"average"}).

\item 'pseudocount': Adds only pseudocount.

\item 'cutoff': In some ecological studies, only strictly positive values
are taken into account. This method keeps only values greater than
\code{threshold} and replaces all other values with \code{value}.

}
}
\examples{
data(GlobalPatterns)
tse <- GlobalPatterns

# By specifying 'method', it is possible to apply different transformations,
# e.g. compositional transformation.
tse <- transformAssay(tse, method = "relabundance")

# The target of transformation can be specified with "assay.type"
# Pseudocount can be added by specifying 'pseudocount'.

# Perform CLR with half of the smallest positive value as pseudocount
tse <- transformAssay(
    tse, assay.type = "counts", method = "clr",
    pseudocount = TRUE
    )

head(assay(tse, "clr"))

# Perform CSS normalization.
tse <- transformAssay(tse, method = "css")
head(assay(tse, "css"))

# With MARGIN, you can specify the if transformation is done for samples or
# for features. Here Z-transformation is done feature-wise.
tse <- transformAssay(tse, method = "standardize", MARGIN = "features")
head(assay(tse, "standardize"))

# Name of the stored table can be specified.
tse <- transformAssay(tse, method="hellinger", name="test")
head(assay(tse, "test"))

# pa returns presence absence table.
tse <- transformAssay(tse, method = "pa")
head(assay(tse, "pa"))

# rank returns ranks of taxa.
tse <- transformAssay(tse, method = "rank")
head(assay(tse, "rank"))

# In order to use other ranking variants, modify the chosen assay directly:
assay(tse, "rank_average", withDimnames = FALSE) <- colRanks(
    assay(tse, "counts"), ties.method = "average", preserveShape = TRUE)

# Using altexp parameter. First agglomerate the data and then apply
# transformation.
tse <- GlobalPatterns
tse <- agglomerateByRanks(tse)
tse <- transformAssay(
    tse, method = "relabundance", altexp = altExpNames(tse))
# The transformation is applied to all alternative experiments
altExp(tse, "Species")

\dontrun{
# philr transformation can be applied if the philr package is installed.
# Subset data b taking only prevalent taxa
tse <- subsetByPrevalent(tse)
# Apply transformation
tse <- transformAssay(tse, method = "philr", pseudocount = 1, MARGIN = 1L)
# The transformed data is added to altExp
altExp(tse, "philr")
}

}
\references{
Paulson, J., Stine, O., Bravo, H. et al. (2013)
Differential abundance analysis for microbial marker-gene surveys
\emph{Nature Methods} 10, 1200–1202.
doi:10.1038/nmeth.2658
}
\seealso{
\itemize{
\item \code{\link[vegan:decostand]{vegan::decostand}}
\item \code{\link[philr:philr]{philr::philr}}
}
}
