% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/summaries.R
\name{summarizeDominance}
\alias{summarizeDominance}
\alias{getUnique}
\alias{getTop}
\alias{summary}
\alias{getTop,SummarizedExperiment-method}
\alias{getUnique,SummarizedExperiment-method}
\alias{summarizeDominance,SummarizedExperiment-method}
\alias{summary,SummarizedExperiment-method}
\title{Summarizing microbiome data}
\usage{
summarizeDominance(x, group = NULL, name = "dominant_taxa", ...)

getUnique(x, ...)

getTop(
  x,
  top = 5L,
  method = c("mean", "sum", "median"),
  assay.type = assay_name,
  assay_name = "counts",
  na.rm = TRUE,
  ...
)

\S4method{getTop}{SummarizedExperiment}(
  x,
  top = 5L,
  method = c("mean", "sum", "median", "prevalence"),
  assay.type = assay_name,
  assay_name = "counts",
  na.rm = TRUE,
  ...
)

\S4method{getUnique}{SummarizedExperiment}(x, rank = NULL, ...)

\S4method{summarizeDominance}{SummarizedExperiment}(x, group = NULL, name = "dominant_taxa", ...)

\S4method{summary}{SummarizedExperiment}(object, assay.type = assay_name, assay_name = "counts")
}
\arguments{
\item{x}{\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}.}

\item{group}{With group, it is possible to group the observations in an
overview. Must be one of the column names of \code{colData}.}

\item{name}{\code{Character scalar}. A name for the column of the
\code{colData} where results will be stored.
(Default: \code{"dominant_taxa"})}

\item{...}{Additional arguments passed on to \code{agglomerateByRank()} when
\code{rank} is specified for \code{summarizeDominance}.}

\item{top}{\code{Numeric scalar}. Determines how many top taxa to return.
Default is to return top five taxa. (Default: \code{5})}

\item{method}{\code{Character scalar}. Specify the method to determine top
taxa. Either sum, mean, median or prevalence. (Default: \code{"mean"})}

\item{assay.type}{\code{Character scalar}. Specifies the name of the
assay used in calculation. (Default: \code{"counts"})}

\item{assay_name}{Deprecated. Use \code{assay.type} instead.}

\item{na.rm}{\code{Logical scalar}. Should NA values be omitted?
(Default: \code{TRUE})}

\item{rank}{\code{Character scalar}. Defines a taxonomic rank. Must be a
value of the output of \code{taxonomyRanks()}. (Default: \code{NULl})}

\item{object}{A
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.}
}
\value{
The \code{getTop} returns a vector of the most \code{top} abundant
\dQuote{FeatureID}s

The \code{getUnique} returns a vector of unique taxa present at a
particular rank

The \code{summarizeDominance} returns an overview in a tibble. It contains
dominant taxa in a column named \code{*name*} and its abundance in the data
set.

The \code{summary} returns a list with two \code{tibble}s
}
\description{
To query a \code{SummarizedExperiment} for interesting features, several
functions are available.
}
\details{
The \code{getTop} extracts the most \code{top} abundant \dQuote{FeatureID}s
in a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.

The \code{getUnique} is a basic function to access different taxa at a
particular taxonomic rank.

\code{summarizeDominance} returns information about most dominant
taxa in a tibble. Information includes their absolute and relative
abundances in whole data set.

The \code{summary} will return a summary of counts for all samples and
features in
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object.
}
\examples{
data(GlobalPatterns)
top_taxa <- getTop(GlobalPatterns,
                       method = "mean",
                       top = 5,
                       assay.type = "counts")
top_taxa

# Use 'detection' to select detection threshold when using prevalence method
top_taxa <- getTop(GlobalPatterns,
                       method = "prevalence",
                       top = 5,
                       assay_name = "counts",
                       detection = 100)
top_taxa
                       
# Top taxa os specific rank
getTop(agglomerateByRank(GlobalPatterns,
                             rank = "Genus",
                             na.rm = TRUE))

# Gets the overview of dominant taxa
dominant_taxa <- summarizeDominance(GlobalPatterns,
                                   rank = "Genus")
dominant_taxa

# With group, it is possible to group observations based on specified groups
# Gets the overview of dominant taxa
dominant_taxa <- summarizeDominance(GlobalPatterns,
                                   rank = "Genus",
                                   group = "SampleType",
                                   na.rm = TRUE)

dominant_taxa

# Get an overview of sample and taxa counts
summary(GlobalPatterns, assay.type= "counts")

# Get unique taxa at a particular taxonomic rank
# sort = TRUE means that output is sorted in alphabetical order
# With na.rm = TRUE, it is possible to remove NAs
# sort and na.rm can also be used in function getTop
getUnique(GlobalPatterns, "Phylum", sort = TRUE)

}
\seealso{
\code{\link[=getPrevalence]{getPrevalent}}

\code{\link[scuttle:perCellQCMetrics]{perCellQCMetrics}},
\code{\link[scuttle:perFeatureQCMetrics]{perFeatureQCMetrics}},
\code{\link[scuttle:addPerCellQC]{addPerCellQC}},
\code{\link[scuttle:addPerFeatureQC]{addPerFeatureQC}},
\code{\link[scuttle:quickPerCellQC]{quickPerCellQC}}
}
